local assets =
{
	Asset("ANIM", "anim/pb.zip"),
    Asset("ATLAS", "images/inventoryimages/pb.xml"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("pb")
    inst.AnimState:SetBuild("pb")
    inst.AnimState:PlayAnimation("BUILD")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddTag("molebait")
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "pb"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/pb.xml"
    inst:AddComponent("selfstacker")

    MakeHauntableLaunchAndSmash(inst)

    return inst
end

return Prefab("pb", fn, assets)